# Prof-TC
# Decembre 2020
# Son mono La440

print("_________________________________________________________")
print("Son mono La440")

# Importation des bibliotheques
import wave
import math
import winsound

Fichier = 'son mono La440.wav' # Nom du fichier qui sera créé
Son = wave.open(Fichier, 'w') # Ouverture fichier en écriture

nbCanal = 1 # Son monophonique (choix d'un seul canal)
nbOctet = 1 # Quantification sur 1 octet soit 8 bits
fech = 44100 # Fréquence d'échantillonage à 44,1 kHz
duree = 1 # Durée du son en seconde (nombre entier)
nbEchantillons = 44100*duree #Nombre d'échantillons

# Liste des paramètres du signal sonore
parametres = (nbCanal, nbOctet, fech, nbEchantillons, 'NONE', 'notcompressed')

Son.setparams(parametres) # Appel des paramètres
f = 440 # Choix de la fréquence du signal sonore

print("Veuillez patienter, création du signal sonore...") # Patience lors de la création du signal sonore

# Représentation du signal sonore par une sinusoïde
for i in range(nbEchantillons): # Boucle d'itération
    val = wave.struct.pack('B',int( (255/2)*(1+math.sin(2*math.pi*f*i/fech)))) # Calculs des Valeurs du signal sonore
    Son.writeframes(val) # Mise en forme du signa sonore
Son.close() # Fin de la boucle d'itération

winsound.PlaySound('son mono La440.wav',winsound.SND_FILENAME) # Lecture du fichier son créé

print("Le signal sonore a été créé")
print("_________________________________________________________")